package gov.va.genisis2.converter;

import java.util.HashSet;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.genisis2.dto.UserRoleTypeDTO;
import gov.va.genisis2.model.RoleType;
import gov.va.genisis2.model.User;
import gov.va.genisis2.model.UserRoleType;
import gov.va.genisis2.model.UserType;
import gov.va.genisis2.util.DateUtil;

/**
 * This class is used to convert UserRoleTypeDTO to UserRoleType entity and
 * vice-versa.
 * 
 * @author PII
 * @author PII
 *
 */
@Component
public class UserRoleTypeConverter implements Converter<UserRoleType, UserRoleTypeDTO> {

	@Autowired
	private RoleTypeConverter roleTypeConverter;

	@Autowired
	private UserTypeConverter userTypeConverter;

	@Override
	public UserRoleTypeDTO convert(UserRoleType userRoleType) {
		UserRoleTypeDTO userRoleTypeDto = new UserRoleTypeDTO();

		userRoleTypeDto.setId(userRoleType.getId());
		userRoleTypeDto.setStartDate(userRoleType.getStartDate());
		userRoleTypeDto.setEndDate(userRoleType.getEndDate());
		userRoleTypeDto.setRoleTypeId(userRoleType.getRoleTypeId());

		RoleType roleType = userRoleType.getRoleType();
		if (null != roleType) {
			userRoleTypeDto.setRoleType(roleTypeConverter.convert(roleType));
		}

		userRoleTypeDto.setUserTypeId(userRoleType.getUserTypeId());

		UserType userType = userRoleType.getUserType();
		if (null != userType) {
			userRoleTypeDto.setUserType(userTypeConverter.convert(userType));
		}

		userRoleTypeDto.setUserId(userRoleType.getUserId());

		return userRoleTypeDto;
	}

	public Set<UserRoleTypeDTO> convertUserRoleTypes(Set<UserRoleType> userRoleTypes) {
		Set<UserRoleTypeDTO> userRoleTypesDtos = null;
		if (!userRoleTypes.isEmpty()) {
			userRoleTypesDtos = new HashSet<>();
			for (UserRoleType userRoleType : userRoleTypes) {
				userRoleTypesDtos.add(convert(userRoleType));
			}
		}

		return userRoleTypesDtos;
	}
	
	public UserRoleType populate(UserRoleType userRoleType, User user, UserType userType, RoleType roleType) {
		UserRoleType usrRoleType = new UserRoleType();

		if (null != userRoleType && userRoleType.getId() > 0) {
			usrRoleType.setId(userRoleType.getId());
		}
		usrRoleType.setUser(user);
		usrRoleType.setUserType(userType);
		usrRoleType.setRoleType(roleType);
		usrRoleType.setStartDate(DateUtil.getTodaysDate());
		
		return usrRoleType;
	}

	/**
	 * @param roleTypeConverter
	 *            the roleTypeConverter to set
	 */
	public void setRoleTypeConverter(RoleTypeConverter roleTypeConverter) {
		this.roleTypeConverter = roleTypeConverter;
	}

	/**
	 * @param userTypeConverter
	 *            the userTypeConverter to set
	 */
	public void setUserTypeConverter(UserTypeConverter userTypeConverter) {
		this.userTypeConverter = userTypeConverter;
	}

}